DROP PROCEDURE [hips].[EpisodeTypeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon
-- Create date: 19 October 2012
-- Description:   Gets a specific record from the EpisodeType Table
-- =============================================
CREATE PROCEDURE [hips].[EpisodeTypeGet] 
(
	@EpisodeTypeId INT = NULL
	,@DateModified DATETIME = NULL
)
AS
BEGIN
SELECT  s.EpisodeTypeId,
		s.Code,
		s.Description,
		s.DateCreated,
		s.UserCreated,
		s.DateModified,
		s.UserModified
		
FROM  hips.EpisodeType s
WHERE (s.EpisodeTypeId = @EpisodeTypeId OR @EpisodeTypeId IS NULL)
AND (s.DateModified > @DateModified OR @DateModified IS NULL)
END
GO

